--[[----------------------------------------------------------------------------
    PhotoContext - Lightroom Plugin

    Uses OpenRouter API with vision models to analyze photos and determine
    their geographic location, then writes GPS coordinates and location
    metadata to the images.
------------------------------------------------------------------------------]]

return {
    LrSdkVersion = 6.0,
    LrSdkMinimumVersion = 4.0,

    LrToolkitIdentifier = "com.brunomaestri.photocontext",
    LrPluginName = "PhotoContext",
    LrPluginInfoUrl = "https://github.com/bmaestrini/photocontext",

    LrPluginInfoProvider = "PluginInfoProvider.lua",

    LrLibraryMenuItems = {
        {
            title = "Analyze with PhotoContext...",
            file = "PhotoContextMenuItem.lua",
            enabledWhen = "photosSelected",
        },
    },

    LrExportMenuItems = {
        {
            title = "Analyze with PhotoContext...",
            file = "PhotoContextMenuItem.lua",
            enabledWhen = "photosSelected",
        },
    },

    VERSION = { major = 1, minor = 0, revision = 0, build = 1 },
}
