# PhotoContext

A Lightroom Classic plugin that uses AI vision models to analyze your photos and automatically identify where they were taken.

## Features

- **AI-Powered Location Detection** - Uses vision models to identify landmarks, architecture, signage, and other visual clues
- **Multiple Model Options** - Choose from GPT-4o Mini (~$0.001/photo), GPT-4o, Claude Sonnet 4, Gemini, or free models (Qwen, Gemini Exp)
- **Accurate GPS Coordinates** - Auto-geocodes identified locations via OpenStreetMap for precise coordinates
- **Full IPTC Support** - Writes location, city, state/province, country, and GPS to photo metadata
- **Batch Processing** - Analyze multiple photos with progress tracking
- **RAW Support** - Automatically converts RAW files for analysis

## Installation

1. Download the `LR_PHOTO_CONTEXT.lrplugin` folder
2. In Lightroom, go to **File > Plug-in Manager**
3. Click **Add** and select the plugin folder
4. Enter your OpenRouter API key in the plugin settings

## Setup

1. Get a free API key at [openrouter.ai](https://openrouter.ai)
2. Open **File > Plug-in Manager > PhotoContext**
3. Enter your API key and click **Test API Connection**

## Usage

1. Select one or more photos in Lightroom
2. Go to **Library > Plug-in Extras > Analyze with PhotoContext**
3. Optionally provide hints (e.g., "Europe trip 2023")
4. Review and apply the detected location metadata

## Pricing

| Model | Cost per Photo | Notes |
|-------|----------------|-------|
| GPT-4o Mini | ~$0.001 | Recommended - 1000 photos ≈ $1 |
| Gemini 2.0 Flash | ~$0.001 | Fast and accurate |
| GPT-4o | ~$0.01 | Higher accuracy |
| Claude Sonnet 4 | ~$0.01 | Higher accuracy |
| Qwen 2.5 VL 7B | Free | May have rate limits |
| Gemini Flash Exp | Free | May have rate limits |

## Requirements

- Lightroom Classic (CC 2015 / v6.0 or later)
- OpenRouter API key (free to create)

## License

Copyright (c) 2025 Bruno Maestrini. All rights reserved.

## Author

Created by Bruno Maestrini
